/******************************************************************************
*                                                  
*  (c) copyright Freescale Semiconductor 2010
*  ALL RIGHTS RESERVED
*
*  File Name:   MMA7660.h
*                                                                          
*  Description: Header File for MMA7660 Acelerometer 
*                                                                                     
*  Assembler:   Codewarrior for HC(S)08 V6.1
*                                            
*  Version:     1.0                                                         
*                                                                                                                                                         
*  Author:      Santiago Lopez [SL](SSE Americas)
*               Martin Bricchi [MB](SSE Americas)
*                                                                                     
*  Location:    Guadalajara,Mexico                                              
*                                                                                                                  
*                                                  
* UPDATED HISTORY:
*
* REV   YYYY.MM.DD  AUTHOR   DESCRIPTION OF CHANGE
* ---   ----------  ------   --------------------- 
* 1.0   2010.11.08   SL/MB      Initial version
* 
******************************************************************************/                                                                        
/* Freescale  is  not  obligated  to  provide  any  support, upgrades or new */
/* releases  of  the Software. Freescale may make changes to the Software at */
/* any time, without any obligation to notify or provide updated versions of */
/* the  Software  to you. Freescale expressly disclaims any warranty for the */
/* Software.  The  Software is provided as is, without warranty of any kind, */
/* either  express  or  implied,  including, without limitation, the implied */
/* warranties  of  merchantability,  fitness  for  a  particular purpose, or */
/* non-infringement.  You  assume  the entire risk arising out of the use or */
/* performance of the Software, or any systems you design using the software */
/* (if  any).  Nothing  may  be construed as a warranty or representation by */
/* Freescale  that  the  Software  or  any derivative work developed with or */
/* incorporating  the  Software  will  be  free  from  infringement  of  the */
/* intellectual property rights of third parties. In no event will Freescale */
/* be  liable,  whether in contract, tort, or otherwise, for any incidental, */
/* special,  indirect, consequential or punitive damages, including, but not */
/* limited  to,  damages  for  any loss of use, loss of time, inconvenience, */
/* commercial loss, or lost profits, savings, or revenues to the full extent */
/* such  may be disclaimed by law. The Software is not fault tolerant and is */
/* not  designed,  manufactured  or  intended by Freescale for incorporation */
/* into  products intended for use or resale in on-line control equipment in */
/* hazardous, dangerous to life or potentially life-threatening environments */
/* requiring  fail-safe  performance,  such  as  in the operation of nuclear */
/* facilities,  aircraft  navigation  or  communication systems, air traffic */
/* control,  direct  life  support machines or weapons systems, in which the */
/* failure  of  products  could  lead  directly to death, personal injury or */
/* severe  physical  or  environmental  damage  (High  Risk Activities). You */
/* specifically  represent and warrant that you will not use the Software or */
/* any  derivative  work of the Software for High Risk Activities.           */
/* Freescale  and the Freescale logos are registered trademarks of Freescale */
/* Semiconductor Inc.                                                        */ 
/*****************************************************************************/

#ifndef _MMA7660_H_
#define _MMA7660_H_


/*****************************************************************************/
/*                                 Includes
/*****************************************************************************/

  
  #include "IICV1Driver.h"
  
/*****************************************************************************/
/*                            Device Definitions
/*****************************************************************************/

  #define MMA7660_Slave_Address     (0x4C << 1)        //Device IIC slave address
  #define MMA7660_Xaxisout          (0x00)
  #define MMA7660_Yaxisout          (0x01)
  #define MMA7660_Zaxisout          (0x02)
  #define MMA7660_Tilt              (0x03)
  #define MMA7660_SRST              (0x04)             //Sampling rate status
  #define MMA7660_SPCNT             (0x05)             //Sleep Count
  #define MMA7660_INTSU             (0x06)             //Interrupt Set Up
  #define MMA7660_Mode              (0x07)             
  #define MMA7660_SR                (0x08)             //AutoWake, Sleep...
  #define MMA7660_PDET              (0x09)             //Tap Detection
  #define MMA7660_PD                (0x0A)             //Tap debounce count
  
/*****************************************************************************/
/*                                Globals
/*****************************************************************************/

  extern UINT8 MMA7660_InterruptSucceded;

/*****************************************************************************/
/*                                Functions
/*****************************************************************************/
  extern void vfnMMA7660Init (void);
  
  extern void vfnMMA7660Write (UINT8 RegisterAdd, UINT8 Data);
  
  extern UINT8 MMA7660Read (UINT8 RegisterAdd);
  
  extern void MMA7660_Interrupt (void);
   
  
#endif